/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4_1.internal.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4_1.internal.AttributeKeys;
import io.opentelemetry.instrumentation.netty.v4_1.internal.client.HttpClientRequestTracingHandler;
import io.opentelemetry.instrumentation.netty.v4_1.internal.client.HttpClientResponseTracingHandler;

public class HttpClientTracingHandler
extends CombinedChannelDuplexHandler<HttpClientResponseTracingHandler, HttpClientRequestTracingHandler> {
    private final Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter;

    public HttpClientTracingHandler(Instrumenter<HttpRequestAndChannel, HttpResponse> instrumenter) {
        super((ChannelInboundHandler)new HttpClientResponseTracingHandler(instrumenter), (ChannelOutboundHandler)new HttpClientRequestTracingHandler(instrumenter));
        this.instrumenter = instrumenter;
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        Context context = (Context)ctx.channel().attr(AttributeKeys.CLIENT_CONTEXT).getAndSet(null);
        HttpRequestAndChannel request = (HttpRequestAndChannel)ctx.channel().attr(HttpClientRequestTracingHandler.HTTP_CLIENT_REQUEST).getAndSet(null);
        HttpResponse response = (HttpResponse)ctx.channel().attr(HttpClientResponseTracingHandler.HTTP_CLIENT_RESPONSE).getAndSet(null);
        Context parentContext = (Context)ctx.channel().attr(AttributeKeys.CLIENT_PARENT_CONTEXT).getAndSet(null);
        if (context != null && request != null) {
            this.instrumenter.end(context, (Object)request, (Object)response, null);
        }
        if (parentContext != null) {
            try (Scope ignored = parentContext.makeCurrent();){
                super.close(ctx, promise);
            }
        } else {
            super.close(ctx, promise);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Context context = (Context)ctx.channel().attr(AttributeKeys.CLIENT_CONTEXT).getAndSet(null);
        HttpRequestAndChannel request = (HttpRequestAndChannel)ctx.channel().attr(HttpClientRequestTracingHandler.HTTP_CLIENT_REQUEST).getAndSet(null);
        HttpResponse response = (HttpResponse)ctx.channel().attr(HttpClientResponseTracingHandler.HTTP_CLIENT_RESPONSE).getAndSet(null);
        Context parentContext = (Context)ctx.channel().attr(AttributeKeys.CLIENT_PARENT_CONTEXT).getAndSet(null);
        if (context != null && request != null) {
            this.instrumenter.end(context, (Object)request, (Object)response, cause);
        }
        if (parentContext != null) {
            try (Scope ignored = parentContext.makeCurrent();){
                super.exceptionCaught(ctx, cause);
            }
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }
}

