/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.common.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import javax.annotation.Nullable;

public final class NettyErrorHolder
implements ImplicitContextKeyed {
    private static final ContextKey<NettyErrorHolder> KEY = ContextKey.named((String)"opentelemetry-netty-error");
    private volatile Throwable error;

    private NettyErrorHolder() {
    }

    public static Context init(Context context) {
        if (context.get(KEY) != null) {
            return context;
        }
        return context.with((ImplicitContextKeyed)new NettyErrorHolder());
    }

    public static void set(Context context, Throwable error) {
        NettyErrorHolder holder = (NettyErrorHolder)context.get(KEY);
        if (holder != null) {
            holder.error = error;
        }
    }

    @Nullable
    public static Throwable getOrDefault(Context context, @Nullable Throwable error) {
        Throwable result = null;
        NettyErrorHolder holder = (NettyErrorHolder)context.get(KEY);
        if (holder != null) {
            result = holder.error;
        }
        return result == null ? error : result;
    }

    public Context storeInContext(Context context) {
        return context.with(KEY, (Object)this);
    }
}

