/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.common.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.time.Instant;

public final class Timer
implements ImplicitContextKeyed {
    private static final ContextKey<Timer> KEY = ContextKey.named((String)"opentelemetry-timer-key");
    private final Instant startTime;
    private final long startNanoTime;

    public static Timer start() {
        return new Timer(Instant.now(), System.nanoTime());
    }

    private Timer(Instant startTime, long startNanoTime) {
        this.startTime = startTime;
        this.startNanoTime = startNanoTime;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant now() {
        long durationNanos = System.nanoTime() - this.startNanoTime;
        return this.startTime().plusNanos(durationNanos);
    }

    public Context storeInContext(Context context) {
        return context.with(KEY, (Object)this);
    }

    public static Timer get(Context context) {
        return (Timer)context.get(KEY);
    }
}

