/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.okhttp.v3_0.OkHttpTelemetryBuilder;
import io.opentelemetry.instrumentation.okhttp.v3_0.TracingCallFactory;
import io.opentelemetry.instrumentation.okhttp.v3_0.TracingInterceptor;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public final class OkHttpTelemetry {
    private final Instrumenter<Request, Response> instrumenter;
    private final ContextPropagators propagators;

    public static OkHttpTelemetry create(OpenTelemetry openTelemetry) {
        return OkHttpTelemetry.builder(openTelemetry).build();
    }

    public static OkHttpTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new OkHttpTelemetryBuilder(openTelemetry);
    }

    OkHttpTelemetry(Instrumenter<Request, Response> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    @Deprecated
    public Interceptor newInterceptor() {
        return new TracingInterceptor(this.instrumenter, this.propagators);
    }

    public Call.Factory newCallFactory(OkHttpClient baseClient) {
        OkHttpClient.Builder builder = baseClient.newBuilder();
        builder.interceptors().add(0, this.newInterceptor());
        OkHttpClient tracingClient = builder.build();
        return new TracingCallFactory(tracingClient);
    }
}

