/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.okhttp.v3_0.OkHttpAttributesGetter;
import io.opentelemetry.instrumentation.okhttp.v3_0.OkHttpTelemetry;
import io.opentelemetry.instrumentation.okhttp.v3_0.internal.OkHttpNetAttributesGetter;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Request;
import okhttp3.Response;

public final class OkHttpTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.okhttp-3.0";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<Request, Response>> additionalExtractors = new ArrayList<AttributesExtractor<Request, Response>>();
    private final HttpClientAttributesExtractorBuilder<Request, Response> httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)OkHttpAttributesGetter.INSTANCE, (NetClientAttributesGetter)new OkHttpNetAttributesGetter());

    OkHttpTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder addAttributesExtractor(AttributesExtractor<Request, Response> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    public OkHttpTelemetry build() {
        OkHttpAttributesGetter httpAttributesGetter = OkHttpAttributesGetter.INSTANCE;
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpClientMetrics.get()).buildInstrumenter(SpanKindExtractor.alwaysClient());
        return new OkHttpTelemetry((Instrumenter<Request, Response>)instrumenter, this.openTelemetry.getPropagators());
    }
}

