/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.okhttp.v3_0.RequestHeaderSetter;
import io.opentelemetry.instrumentation.okhttp.v3_0.TracingCallFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

final class TracingInterceptor
implements Interceptor {
    private final Instrumenter<Request, Response> instrumenter;
    private final ContextPropagators propagators;

    TracingInterceptor(Instrumenter<Request, Response> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        Context parentContext = TracingCallFactory.getCallingContextForRequest(request);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            return chain.proceed(chain.request());
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        request = this.injectContextToRequest(request, context);
        try (Scope ignored = context.makeCurrent();){
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.instrumenter.end(context, (Object)request, null, (Throwable)e);
            throw e;
        }
        this.instrumenter.end(context, (Object)request, (Object)response, null);
        return response;
    }

    private Request injectContextToRequest(Request request, Context context) {
        Request.Builder requestBuilder = request.newBuilder();
        this.propagators.getTextMapPropagator().inject(context, (Object)requestBuilder, (TextMapSetter)RequestHeaderSetter.INSTANCE);
        return requestBuilder.build();
    }
}

