/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientResendCount;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import java.io.IOException;
import java.time.Instant;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class ConnectionErrorSpanInterceptor
implements Interceptor {
    private final Instrumenter<Request, Response> instrumenter;

    public ConnectionErrorSpanInterceptor(Instrumenter<Request, Response> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Context parentContext = Context.current();
        Response response = null;
        Throwable error = null;
        Instant startTime = Instant.now();
        try {
            Response response2 = response = chain.proceed(request);
            return response2;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            if (HttpClientResendCount.get((Context)parentContext) == 0 && this.instrumenter.shouldStart(parentContext, (Object)request)) {
                InstrumenterUtil.startAndEnd(this.instrumenter, (Context)parentContext, (Object)request, (Object)response, (Throwable)error, (Instant)startTime, (Instant)Instant.now());
            }
        }
    }
}

