/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.okhttp.v3_0.internal.OkHttpAttributesGetter;
import java.util.List;
import java.util.function.Consumer;
import okhttp3.Request;
import okhttp3.Response;

public final class OkHttpInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.okhttp-3.0";

    public static Instrumenter<Request, Response> create(OpenTelemetry openTelemetry, Consumer<HttpClientAttributesExtractorBuilder<Request, Response>> extractorConfigurer, Consumer<HttpSpanNameExtractorBuilder<Request>> spanNameExtractorConfigurer, List<AttributesExtractor<Request, Response>> additionalAttributesExtractors, boolean emitExperimentalHttpClientMetrics) {
        OkHttpAttributesGetter httpAttributesGetter = OkHttpAttributesGetter.INSTANCE;
        HttpClientAttributesExtractorBuilder extractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        extractorConfigurer.accept((HttpClientAttributesExtractorBuilder<Request, Response>)extractorBuilder);
        HttpSpanNameExtractorBuilder httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpCommonAttributesGetter)httpAttributesGetter);
        spanNameExtractorConfigurer.accept((HttpSpanNameExtractorBuilder<Request>)httpSpanNameExtractorBuilder);
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)httpSpanNameExtractorBuilder.build()).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(extractorBuilder.build()).addAttributesExtractors(additionalAttributesExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (emitExperimentalHttpClientMetrics) {
            builder.addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private OkHttpInstrumenterFactory() {
    }
}

