/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.okhttp.v3_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpClientInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.okhttp.v3_0.OkHttpTelemetry;
import io.opentelemetry.instrumentation.okhttp.v3_0.internal.OkHttpClientInstrumenterBuilderFactory;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import okhttp3.Interceptor;
import okhttp3.Response;

public final class OkHttpTelemetryBuilder {
    private final DefaultHttpClientInstrumenterBuilder<Interceptor.Chain, Response> builder;

    OkHttpTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = OkHttpClientInstrumenterBuilderFactory.create(openTelemetry);
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder addAttributeExtractor(AttributesExtractor<? super Interceptor.Chain, ? super Response> attributesExtractor) {
        this.builder.addAttributeExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.builder.setEmitExperimentalHttpClientMetrics(emitExperimentalHttpClientMetrics);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<? super Interceptor.Chain>, ? extends SpanNameExtractor<? super Interceptor.Chain>> spanNameExtractorTransformer) {
        this.builder.setSpanNameExtractor(spanNameExtractorTransformer);
        return this;
    }

    public OkHttpTelemetry build() {
        return new OkHttpTelemetry((Instrumenter<Interceptor.Chain, Response>)this.builder.build(), this.builder.getOpenTelemetry().getPropagators());
    }
}

