/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.reactor.v3_1;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.reactor.v3_1.ContextPropagationOperator;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;

public class TracingSubscriber<T>
implements CoreSubscriber<T> {
    private final Context traceContext;
    private final Subscriber<? super T> subscriber;
    private final reactor.util.context.Context context;
    private final boolean hasContextToPropagate;

    public TracingSubscriber(Subscriber<? super T> subscriber, reactor.util.context.Context ctx) {
        this(subscriber, ctx, Context.current());
    }

    public TracingSubscriber(Subscriber<? super T> subscriber, reactor.util.context.Context ctx, Context contextToPropagate) {
        this.subscriber = subscriber;
        this.context = ctx;
        this.traceContext = ContextPropagationOperator.getOpenTelemetryContext(ctx, contextToPropagate);
        this.hasContextToPropagate = this.traceContext == null ? false : Span.fromContext((Context)this.traceContext).getSpanContext().isValid();
    }

    public void onSubscribe(Subscription subscription) {
        this.withActiveSpan(() -> this.subscriber.onSubscribe(subscription));
    }

    public void onNext(T o) {
        this.withActiveSpan(() -> this.subscriber.onNext(o));
    }

    public void onError(Throwable throwable) {
        this.withActiveSpan(() -> this.subscriber.onError(throwable));
    }

    public void onComplete() {
        this.withActiveSpan(() -> this.subscriber.onComplete());
    }

    public reactor.util.context.Context currentContext() {
        return this.context;
    }

    private void withActiveSpan(Runnable runnable) {
        if (this.hasContextToPropagate) {
            try (Scope ignored = this.traceContext.makeCurrent();){
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }
}

