/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import javax.annotation.Nullable;

public final class OsResource {
    private static final Resource INSTANCE = OsResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    static Resource buildResource() {
        String os;
        try {
            os = System.getProperty("os.name");
        }
        catch (SecurityException t) {
            return Resource.empty();
        }
        if (os == null) {
            return Resource.empty();
        }
        AttributesBuilder attributes = Attributes.builder();
        String osName = OsResource.getOs(os);
        if (osName != null) {
            attributes.put(ResourceAttributes.OS_TYPE, (Object)osName);
        }
        String version = null;
        try {
            version = System.getProperty("os.version");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String osDescription = version != null ? os + ' ' + version : os;
        attributes.put(ResourceAttributes.OS_DESCRIPTION, (Object)osDescription);
        return Resource.create((Attributes)attributes.build(), (String)"https://opentelemetry.io/schemas/1.16.0");
    }

    @Nullable
    private static String getOs(String os) {
        if ((os = os.toLowerCase()).startsWith("windows")) {
            return "windows";
        }
        if (os.startsWith("linux")) {
            return "linux";
        }
        if (os.startsWith("mac")) {
            return "darwin";
        }
        if (os.startsWith("freebsd")) {
            return "freebsd";
        }
        if (os.startsWith("netbsd")) {
            return "netbsd";
        }
        if (os.startsWith("openbsd")) {
            return "openbsd";
        }
        if (os.startsWith("dragonflybsd")) {
            return "dragonflybsd";
        }
        if (os.startsWith("hp-ux")) {
            return "hpux";
        }
        if (os.startsWith("aix")) {
            return "aix";
        }
        if (os.startsWith("solaris")) {
            return "solaris";
        }
        if (os.startsWith("z/os")) {
            return "z_os";
        }
        return null;
    }

    private OsResource() {
    }
}

