/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;

public final class ProcessRuntimeResource {
    private static final Resource INSTANCE = ProcessRuntimeResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    static Resource buildResource() {
        try {
            String name = System.getProperty("java.runtime.name");
            String version = System.getProperty("java.runtime.version");
            String description = System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
            return Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.PROCESS_RUNTIME_NAME, (Object)name, (AttributeKey)ResourceAttributes.PROCESS_RUNTIME_VERSION, (Object)version, (AttributeKey)ResourceAttributes.PROCESS_RUNTIME_DESCRIPTION, (Object)description), (String)"https://opentelemetry.io/schemas/1.19.0");
        }
        catch (SecurityException ignored) {
            return Resource.empty();
        }
    }

    private ProcessRuntimeResource() {
    }
}

