/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public final class GarbageCollector {
    private static final AttributeKey<String> GC_KEY = AttributeKey.stringKey((String)"gc");

    @Deprecated
    public static void registerObservers() {
        GarbageCollector.registerObservers(GlobalOpenTelemetry.get());
    }

    public static void registerObservers(OpenTelemetry openTelemetry) {
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        Meter meter = openTelemetry.getMeterProvider().get(GarbageCollector.class.getName());
        ArrayList<Attributes> labelSets = new ArrayList<Attributes>(garbageCollectors.size());
        for (GarbageCollectorMXBean gc : garbageCollectors) {
            labelSets.add(Attributes.of(GC_KEY, (Object)gc.getName()));
        }
        meter.counterBuilder("runtime.jvm.gc.time").setDescription("Time spent in a given JVM garbage collector in milliseconds.").setUnit("ms").buildWithCallback(resultLongObserver -> {
            for (int i = 0; i < garbageCollectors.size(); ++i) {
                resultLongObserver.record(((GarbageCollectorMXBean)garbageCollectors.get(i)).getCollectionTime(), (Attributes)labelSets.get(i));
            }
        });
        meter.counterBuilder("runtime.jvm.gc.count").setDescription("The number of collections that have occurred for a given JVM garbage collector.").setUnit("collections").buildWithCallback(resultLongObserver -> {
            for (int i = 0; i < garbageCollectors.size(); ++i) {
                resultLongObserver.record(((GarbageCollectorMXBean)garbageCollectors.get(i)).getCollectionCount(), (Attributes)labelSets.get(i));
            }
        });
    }

    private GarbageCollector() {
    }
}

