/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class MemoryPools {
    private static final AttributeKey<String> TYPE_KEY = AttributeKey.stringKey((String)"type");
    private static final AttributeKey<String> POOL_KEY = AttributeKey.stringKey((String)"pool");
    private static final String HEAP = "heap";
    private static final String NON_HEAP = "non_heap";

    @Deprecated
    public static void registerObservers() {
        MemoryPools.registerObservers(GlobalOpenTelemetry.get());
    }

    public static void registerObservers(OpenTelemetry openTelemetry) {
        List<MemoryPoolMXBean> poolBeans = ManagementFactory.getMemoryPoolMXBeans();
        Meter meter = openTelemetry.getMeter("io.opentelemetry.runtime-metrics");
        meter.upDownCounterBuilder("process.runtime.jvm.memory.usage").setDescription("Measure of memory used").setUnit("By").buildWithCallback(MemoryPools.callback(poolBeans, MemoryUsage::getUsed));
        meter.upDownCounterBuilder("process.runtime.jvm.memory.init").setDescription("Measure of initial memory requested").setUnit("By").buildWithCallback(MemoryPools.callback(poolBeans, MemoryUsage::getInit));
        meter.upDownCounterBuilder("process.runtime.jvm.memory.committed").setDescription("Measure of memory committed").setUnit("By").buildWithCallback(MemoryPools.callback(poolBeans, MemoryUsage::getCommitted));
        meter.upDownCounterBuilder("process.runtime.jvm.memory.limit").setDescription("Measure of max obtainable memory").setUnit("By").buildWithCallback(MemoryPools.callback(poolBeans, MemoryUsage::getMax));
    }

    static Consumer<ObservableLongMeasurement> callback(List<MemoryPoolMXBean> poolBeans, Function<MemoryUsage, Long> extractor) {
        ArrayList<Attributes> attributeSets = new ArrayList<Attributes>(poolBeans.size());
        for (MemoryPoolMXBean pool : poolBeans) {
            attributeSets.add(Attributes.builder().put(POOL_KEY, (Object)pool.getName()).put(TYPE_KEY, (Object)MemoryPools.memoryType(pool.getType())).build());
        }
        return measurement -> {
            for (int i = 0; i < poolBeans.size(); ++i) {
                Attributes attributes = (Attributes)attributeSets.get(i);
                long value = (Long)extractor.apply(((MemoryPoolMXBean)poolBeans.get(i)).getUsage());
                if (value == -1L) continue;
                measurement.record(value, attributes);
            }
        };
    }

    private static String memoryType(MemoryType memoryType) {
        switch (memoryType) {
            case HEAP: {
                return HEAP;
            }
            case NON_HEAP: {
                return NON_HEAP;
            }
        }
        return "unknown";
    }

    private MemoryPools() {
    }
}

