/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;

public final class Threads {
    static final Threads INSTANCE = new Threads();
    static final AttributeKey<Boolean> DAEMON = AttributeKey.booleanKey((String)"daemon");

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return INSTANCE.registerObservers(openTelemetry, ManagementFactory.getThreadMXBean());
    }

    List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, ThreadMXBean threadBean) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.threads.count").setDescription("Number of executing threads").setUnit("{thread}").buildWithCallback(observableMeasurement -> {
            observableMeasurement.record((long)threadBean.getDaemonThreadCount(), Attributes.builder().put(DAEMON, (Object)true).build());
            observableMeasurement.record((long)(threadBean.getThreadCount() - threadBean.getDaemonThreadCount()), Attributes.builder().put(DAEMON, (Object)false).build());
        }));
        return observables;
    }

    private Threads() {
    }
}

