/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.web;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.web.v3_1.SpringWebTelemetry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestClient;

public final class RestClientBeanPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<OpenTelemetry> openTelemetryProvider;

    public RestClientBeanPostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider) {
        this.openTelemetryProvider = openTelemetryProvider;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof RestClient) {
            RestClient restClient = (RestClient)bean;
            return RestClientBeanPostProcessor.addRestClientInterceptorIfNotPresent(restClient, (OpenTelemetry)this.openTelemetryProvider.getObject());
        }
        return bean;
    }

    private static RestClient addRestClientInterceptorIfNotPresent(RestClient restClient, OpenTelemetry openTelemetry) {
        ClientHttpRequestInterceptor instrumentationInterceptor = SpringWebTelemetry.create((OpenTelemetry)openTelemetry).newInterceptor();
        return restClient.mutate().requestInterceptors(interceptors -> {
            if (interceptors.stream().noneMatch(interceptor -> interceptor.getClass() == instrumentationInterceptor.getClass())) {
                interceptors.add(0, instrumentationInterceptor);
            }
        }).build();
    }
}

