/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.httpclients.webclient;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.client.WebClientTracingFilter;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

final class WebClientBeanPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<OpenTelemetry> openTelemetryProvider;

    WebClientBeanPostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider) {
        this.openTelemetryProvider = openTelemetryProvider;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof WebClient) {
            WebClient webClient = (WebClient)bean;
            return WebClientBeanPostProcessor.wrapBuilder(this.openTelemetryProvider, webClient.mutate()).build();
        }
        if (bean instanceof WebClient.Builder) {
            WebClient.Builder webClientBuilder = (WebClient.Builder)bean;
            return WebClientBeanPostProcessor.wrapBuilder(this.openTelemetryProvider, webClientBuilder);
        }
        return bean;
    }

    private static WebClient.Builder wrapBuilder(ObjectProvider<OpenTelemetry> openTelemetryProvider, WebClient.Builder webClientBuilder) {
        OpenTelemetry openTelemetry = (OpenTelemetry)openTelemetryProvider.getIfUnique();
        if (openTelemetry != null) {
            return webClientBuilder.filters(WebClientBeanPostProcessor.webClientFilterFunctionConsumer(openTelemetry));
        }
        return webClientBuilder;
    }

    private static Consumer<List<ExchangeFilterFunction>> webClientFilterFunctionConsumer(OpenTelemetry openTelemetry) {
        return functions -> {
            if (functions.stream().noneMatch(filter -> filter instanceof WebClientTracingFilter)) {
                WebClientTracingFilter.addFilter((OpenTelemetry)openTelemetry, (List)functions);
            }
        };
    }
}

