/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.webmvc;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.webmvc.WebMvcProperties;
import io.opentelemetry.instrumentation.spring.webmvc.SpringWebMvcTracing;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@EnableConfigurationProperties(value={WebMvcProperties.class})
@ConditionalOnProperty(prefix="otel.springboot.web", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={OncePerRequestFilter.class})
public class WebMvcFilterAutoConfiguration {
    @Bean
    public Filter otelWebMvcTracingFilter(OpenTelemetry openTelemetry) {
        return SpringWebMvcTracing.create((OpenTelemetry)openTelemetry).newServletFilter();
    }
}

