/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.test;

import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.ConnectionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.ValueStore;
import io.r2dbc.spi.Connection;

public final class MockConnectionInfo
implements ConnectionInfo {
    private Connection originalConnection;
    private String connectionId;
    private boolean isClosed;
    private int transactionCount;
    private int commitCount;
    private int rollbackCount;
    private ValueStore valueStore;

    public static Builder builder() {
        return new Builder();
    }

    public static MockConnectionInfo empty() {
        return MockConnectionInfo.builder().build();
    }

    private MockConnectionInfo(Builder builder) {
        this.originalConnection = builder.originalConnection;
        this.connectionId = builder.connectionId;
        this.isClosed = builder.isClosed;
        this.transactionCount = builder.transactionCount;
        this.commitCount = builder.commitCount;
        this.rollbackCount = builder.rollbackCount;
        this.valueStore = builder.valueStore;
    }

    @Override
    public Connection getOriginalConnection() {
        return this.originalConnection;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public void incrementTransactionCount() {
    }

    @Override
    public void incrementCommitCount() {
    }

    @Override
    public void incrementRollbackCount() {
    }

    @Override
    public int getTransactionCount() {
        return this.transactionCount;
    }

    @Override
    public int getCommitCount() {
        return this.commitCount;
    }

    @Override
    public int getRollbackCount() {
        return this.rollbackCount;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    @Override
    public ValueStore getValueStore() {
        return this.valueStore;
    }

    public static final class Builder {
        private Connection originalConnection;
        private String connectionId;
        private boolean isClosed;
        private int transactionCount;
        private int commitCount;
        private int rollbackCount;
        private ValueStore valueStore = ValueStore.create();

        private Builder() {
        }

        public Builder originalConnection(Connection originalConnection) {
            this.originalConnection = originalConnection;
            return this;
        }

        public Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public Builder isClosed(boolean isClosed) {
            this.isClosed = isClosed;
            return this;
        }

        public Builder transactionCount(int transactionCount) {
            this.transactionCount = transactionCount;
            return this;
        }

        public Builder commitCount(int commitCount) {
            this.commitCount = commitCount;
            return this;
        }

        public Builder rollbackCount(int rollbackCount) {
            this.rollbackCount = rollbackCount;
            return this;
        }

        public Builder valueStore(ValueStore valueStore) {
            this.valueStore = valueStore;
            return this;
        }

        public MockConnectionInfo build() {
            return new MockConnectionInfo(this);
        }
    }
}

