/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal;

import io.opentelemetry.instrumentation.api.incubator.semconv.db.internal.SqlCommenterUtil;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.ProxyConfig;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.ConnectionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.StatementInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.ValueStore;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.listener.BindParameterConverter;
import java.util.HashMap;
import java.util.Map;

public final class R2dbcSqlCommenterUtil {
    private static final String KEY_ORIGINAL_QUERY_MAP = "originalQueryMap";

    public static void configure(ProxyConfig proxyConfig) {
        proxyConfig.setBindParameterConverter(new BindParameterConverter(){

            @Override
            public String onCreateStatement(String query, StatementInfo info) {
                String modifiedQuery = SqlCommenterUtil.processQuery((String)query);
                if (!modifiedQuery.equals(query)) {
                    R2dbcSqlCommenterUtil.storeQuery(info.getConnectionInfo(), modifiedQuery, query);
                }
                return modifiedQuery;
            }
        });
    }

    private static Map<String, String> getOriginalQueryMap(ValueStore valueStore) {
        return valueStore.get(KEY_ORIGINAL_QUERY_MAP, Map.class);
    }

    private static void storeQuery(ConnectionInfo connectionInfo, String modifiedQuery, String originalQuery) {
        ValueStore valueStore = connectionInfo.getValueStore();
        Map<String, String> queryMap = R2dbcSqlCommenterUtil.getOriginalQueryMap(valueStore);
        if (queryMap == null) {
            queryMap = new HashMap<String, String>();
            valueStore.put(KEY_ORIGINAL_QUERY_MAP, queryMap);
        }
        queryMap.put(modifiedQuery, originalQuery);
    }

    static String getOriginalQuery(ConnectionInfo connectionInfo, String query) {
        Map<String, String> queryMap = R2dbcSqlCommenterUtil.getOriginalQueryMap(connectionInfo.getValueStore());
        if (queryMap == null) {
            return query;
        }
        return queryMap.getOrDefault(query, query);
    }

    static void clearQueries(ConnectionInfo connectionInfo) {
        connectionInfo.getValueStore().remove(KEY_ORIGINAL_QUERY_MAP);
    }

    private R2dbcSqlCommenterUtil() {
    }
}

