/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.internal.SqlCommenter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.R2dbcTelemetryBuilder;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal.DbExecution;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal.R2dbcSqlCommenterUtil;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.internal.TraceProxyListener;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.ProxyConnectionFactory;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;

public final class R2dbcTelemetry {
    private final Instrumenter<DbExecution, Void> instrumenter;
    private final SqlCommenter sqlCommenter;

    public static R2dbcTelemetry create(OpenTelemetry openTelemetry) {
        return R2dbcTelemetry.builder(openTelemetry).build();
    }

    public static R2dbcTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new R2dbcTelemetryBuilder(openTelemetry);
    }

    R2dbcTelemetry(Instrumenter<DbExecution, Void> instrumenter, SqlCommenter sqlCommenter) {
        this.instrumenter = instrumenter;
        this.sqlCommenter = sqlCommenter;
    }

    public ConnectionFactory wrapConnectionFactory(ConnectionFactory originalFactory, ConnectionFactoryOptions factoryOptions) {
        ProxyConfig proxyConfig = new ProxyConfig();
        if (this.sqlCommenter.isEnabled()) {
            R2dbcSqlCommenterUtil.configure(proxyConfig, this.sqlCommenter);
        }
        proxyConfig.addListener(new TraceProxyListener(this.instrumenter, factoryOptions));
        return ProxyConnectionFactory.builder(originalFactory, proxyConfig).build();
    }
}

