/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

class EmbeddedConfigFile {
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(.+)\\[(\\d+)]$");
    private static final ObjectMapper MAPPER = new ObjectMapper().setDefaultSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.AS_EMPTY));

    private EmbeddedConfigFile() {
    }

    static OpenTelemetryConfigurationModel extractModel(ConfigurableEnvironment environment) {
        Map<String, String> props = EmbeddedConfigFile.extractSpringProperties(environment);
        return EmbeddedConfigFile.convertToOpenTelemetryConfigurationModel(props);
    }

    private static Map<String, String> extractSpringProperties(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        HashMap<String, String> props = new HashMap<String, String>();
        for (PropertySource propertySource : propertySources) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String propertyName : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                if (!propertyName.startsWith("otel.")) continue;
                String property = environment.getProperty(propertyName);
                if (Objects.equals(property, "")) {
                    property = null;
                }
                props.put(propertyName.substring("otel.".length()), property);
            }
        }
        if (props.isEmpty()) {
            throw new IllegalStateException("No properties found with prefix 'otel.' - this should not happen, because we checked 'environment.getProperty(\"otel.file_format\", String.class) != null' earlier");
        }
        return props;
    }

    static OpenTelemetryConfigurationModel convertToOpenTelemetryConfigurationModel(Map<String, String> flatProps) {
        Map<String, Object> nested = EmbeddedConfigFile.convertFlatPropsToNested(flatProps);
        return (OpenTelemetryConfigurationModel)EmbeddedConfigFile.getObjectMapper().convertValue(nested, OpenTelemetryConfigurationModel.class);
    }

    static ObjectMapper getObjectMapper() {
        return MAPPER;
    }

    static Map<String, Object> convertFlatPropsToNested(Map<String, String> flatProps) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : flatProps.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String[] parts = key.split("\\.");
            Map<String, Object> current = result;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                boolean isLast = i == parts.length - 1;
                Matcher matcher = ARRAY_PATTERN.matcher(part);
                if (matcher.matches()) {
                    String arrayName = matcher.group(1);
                    int index = Integer.parseInt(matcher.group(2));
                    ArrayList list = (ArrayList)current.computeIfAbsent(arrayName, k -> new ArrayList());
                    list.ensureCapacity(index + 1);
                    while (list.size() <= index) {
                        list.add(null);
                    }
                    if (isLast) {
                        list.set(index, value);
                        continue;
                    }
                    current = (Map)list.get(index);
                    if (current != null) continue;
                    current = new HashMap();
                    list.set(index, current);
                    continue;
                }
                if (isLast) {
                    current.put(part, value);
                    continue;
                }
                if (!current.containsKey(part)) {
                    current.put(part, new HashMap());
                }
                current = (Map)current.get(part);
            }
        }
        return result;
    }

    static {
        MAPPER.configOverride(String.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Integer.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Double.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
        MAPPER.configOverride(Boolean.class).setSetterInfo(JsonSetter.Value.forValueNulls((Nulls)Nulls.SET));
    }
}

