/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.instrumentation.config.bridge.DeclarativeConfigPropertiesBridgeBuilder;
import io.opentelemetry.instrumentation.spring.autoconfigure.EmbeddedConfigFile;
import io.opentelemetry.instrumentation.spring.autoconfigure.SpringConfigProvider;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.DeclarativeConfigDisabled;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.DeclarativeConfigEnabled;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.OtelDisabled;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.OtelEnabled;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.OtelMapConverter;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.ConfigPropertiesBridge;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtelResourceProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtelSpringProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtlpExporterProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.SpringConfigProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.resources.DistroComponentProvider;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.resources.DistroVersionResourceProvider;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.resources.ResourceCustomizerProvider;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.resources.SpringResourceProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.autoconfigure.internal.AutoConfigureUtil;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.extension.incubator.ExtendedOpenTelemetrySdk;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationCustomizerProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@Configuration
public class OpenTelemetryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetryAutoConfiguration.class);

    private static void logStart() {
        logger.info("OpenTelemetry Spring Boot starter ({}) has been started", (Object)EmbeddedInstrumentationProperties.findVersion((String)"io.opentelemetry.spring-boot-autoconfigure"));
    }

    static class OpenTelemetrySdkComponentLoader
    implements ComponentLoader {
        private final ApplicationContext applicationContext;
        private final SpiHelper spiHelper = SpiHelper.create((ClassLoader)OpenTelemetrySdkComponentLoader.class.getClassLoader());

        public OpenTelemetrySdkComponentLoader(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public <T> Iterable<T> load(Class<T> spiClass) {
            List spi = this.spiHelper.load(spiClass);
            List beans = this.applicationContext.getBeanProvider(spiClass).orderedStream().collect(Collectors.toList());
            spi.addAll(beans);
            return spi;
        }
    }

    @Configuration
    @ConditionalOnBean(value={OpenTelemetry.class})
    @ConditionalOnMissingBean(value={InstrumentationConfig.class})
    static class FallbackInstrumentationConfig {
        FallbackInstrumentationConfig() {
        }

        @Bean
        public InstrumentationConfig instrumentationConfig(ConfigProperties properties) {
            return new ConfigPropertiesBridge(properties, null);
        }
    }

    @Configuration
    @ConditionalOnBean(value={OpenTelemetry.class})
    @ConditionalOnMissingBean(value={ConfigProperties.class})
    static class FallbackConfigProperties {
        FallbackConfigProperties() {
        }

        @Bean
        public ConfigProperties otelProperties(ApplicationContext applicationContext) {
            return DefaultConfigProperties.create(Collections.emptyMap(), (ComponentLoader)new OpenTelemetrySdkComponentLoader(applicationContext));
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    @Conditional(value={OtelDisabled.class})
    static class DisabledOpenTelemetrySdkConfig {
        DisabledOpenTelemetrySdkConfig() {
        }

        @Bean
        public OpenTelemetry openTelemetry() {
            logger.info("OpenTelemetry Spring Boot starter has been disabled");
            return OpenTelemetry.noop();
        }

        @Bean
        public ConfigProperties otelProperties() {
            return DefaultConfigProperties.createFromMap(Collections.emptyMap());
        }

        @Bean
        public InstrumentationConfig instrumentationConfig(ConfigProperties properties) {
            return new ConfigPropertiesBridge(properties, null);
        }

        @Configuration
        @Conditional(value={DeclarativeConfigDisabled.class})
        static class PropertiesConfig {
            PropertiesConfig() {
            }

            @Bean
            OtelMapConverter otelMapConverter() {
                return new OtelMapConverter();
            }
        }
    }

    @Configuration
    @Conditional(value={OtelEnabled.class})
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    static class OpenTelemetrySdkConfig {

        @Configuration
        @Conditional(value={DeclarativeConfigEnabled.class})
        static class EmbeddedConfigFileConfig {
            EmbeddedConfigFileConfig() {
            }

            @Bean
            public OpenTelemetryConfigurationModel openTelemetryConfigurationModel(ConfigurableEnvironment environment) throws IOException {
                return EmbeddedConfigFile.extractModel(environment);
            }

            @Bean
            public OpenTelemetry openTelemetry(OpenTelemetryConfigurationModel model, ApplicationContext applicationContext) {
                ExtendedOpenTelemetrySdk sdk = DeclarativeConfiguration.create((OpenTelemetryConfigurationModel)model, (ComponentLoader)new OpenTelemetrySdkComponentLoader(applicationContext));
                Runtime.getRuntime().addShutdownHook(new Thread(() -> ((OpenTelemetrySdk)sdk).close()));
                OpenTelemetryAutoConfiguration.logStart();
                return sdk;
            }

            @Bean
            public ConfigProvider configProvider(OpenTelemetryConfigurationModel model) {
                return SpringConfigProvider.create(model);
            }

            @Bean
            public ConfigProperties otelProperties(ConfigProvider configProvider) {
                return new DeclarativeConfigPropertiesBridgeBuilder().buildFromInstrumentationConfig(configProvider.getInstrumentationConfig());
            }

            @Bean
            public InstrumentationConfig instrumentationConfig(ConfigProperties properties, ConfigProvider configProvider) {
                return new ConfigPropertiesBridge(properties, configProvider);
            }

            @Bean
            public DeclarativeConfigurationCustomizerProvider distroConfigurationCustomizerProvider() {
                return new ResourceCustomizerProvider();
            }

            @Bean
            public ComponentProvider distroComponentProvider() {
                return new DistroComponentProvider();
            }
        }

        @Configuration
        @EnableConfigurationProperties(value={OtlpExporterProperties.class, OtelResourceProperties.class, OtelSpringProperties.class})
        @Conditional(value={DeclarativeConfigDisabled.class})
        static class PropertiesConfig {
            PropertiesConfig() {
            }

            @Bean
            public ResourceProvider otelSpringResourceProvider(Optional<BuildProperties> buildProperties) {
                return new SpringResourceProvider(buildProperties);
            }

            @Bean
            public ResourceProvider otelDistroVersionResourceProvider() {
                return new DistroVersionResourceProvider();
            }

            @Bean
            @ConfigurationPropertiesBinding
            OtelMapConverter otelMapConverter() {
                return new OtelMapConverter();
            }

            @Bean
            public AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk(Environment env, OtlpExporterProperties otlpExporterProperties, OtelResourceProperties resourceProperties, OtelSpringProperties otelSpringProperties, ApplicationContext applicationContext) {
                return AutoConfigureUtil.setConfigPropertiesCustomizer((AutoConfiguredOpenTelemetrySdkBuilder)AutoConfiguredOpenTelemetrySdk.builder().setComponentLoader((ComponentLoader)new OpenTelemetrySdkComponentLoader(applicationContext)), c -> SpringConfigProperties.create(env, otlpExporterProperties, resourceProperties, otelSpringProperties, c)).build();
            }

            @Bean
            public OpenTelemetry openTelemetry(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
                OpenTelemetryAutoConfiguration.logStart();
                return autoConfiguredOpenTelemetrySdk.getOpenTelemetrySdk();
            }

            @Bean
            public InstrumentationConfig instrumentationConfig(ConfigProperties properties) {
                return new ConfigPropertiesBridge(properties);
            }

            @Bean
            public ConfigProperties otelProperties(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
                return Objects.requireNonNull(AutoConfigureUtil.getConfig((AutoConfiguredOpenTelemetrySdk)autoConfiguredOpenTelemetrySdk));
            }
        }
    }
}

