/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure;

import com.fasterxml.jackson.core.type.TypeReference;
import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.instrumentation.spring.autoconfigure.EmbeddedConfigFile;
import io.opentelemetry.instrumentation.spring.autoconfigure.SpringDeclarativeConfigProperties;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

final class SpringConfigProvider
implements ConfigProvider {
    @Nullable
    private final DeclarativeConfigProperties instrumentationConfig;

    private SpringConfigProvider(OpenTelemetryConfigurationModel model, ComponentLoader componentLoader) {
        DeclarativeConfigProperties configProperties = SpringConfigProvider.toConfigProperties(model, componentLoader);
        this.instrumentationConfig = configProperties.getStructured("instrumentation/development");
    }

    private static DeclarativeConfigProperties toConfigProperties(Object model, ComponentLoader componentLoader) {
        Map<String, Object> configurationMap = (Map<String, Object>)EmbeddedConfigFile.getObjectMapper().convertValue(model, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (configurationMap == null) {
            configurationMap = Collections.emptyMap();
        }
        return SpringDeclarativeConfigProperties.create(configurationMap, componentLoader);
    }

    static SpringConfigProvider create(OpenTelemetryConfigurationModel model) {
        return new SpringConfigProvider(model, ComponentLoader.forClassLoader((ClassLoader)SpringConfigProvider.class.getClassLoader()));
    }

    @Nullable
    public DeclarativeConfigProperties getInstrumentationConfig() {
        return this.instrumentationConfig;
    }

    public String toString() {
        return "SpringConfigProvider{instrumentationConfig=" + this.instrumentationConfig + '}';
    }
}

