/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.springframework.core.env.Environment;

public class EarlyConfig {
    private EarlyConfig() {
    }

    public static boolean otelEnabled(Environment environment) {
        boolean disabled = (Boolean)environment.getProperty(EarlyConfig.getPropertyName(environment, "otel.sdk.disabled", "otel.disabled"), Boolean.class, (Object)false);
        return !disabled;
    }

    public static boolean isDeclarativeConfig(Environment environment) {
        return environment.getProperty("otel.file_format", String.class) != null;
    }

    public static boolean isDefaultEnabled(Environment environment) {
        if (EarlyConfig.isDeclarativeConfig(environment)) {
            String mode;
            switch (mode = (String)environment.getProperty("otel.instrumentation/development.java.spring_starter.instrumentation_mode", String.class, (Object)"default")) {
                case "none": {
                    return false;
                }
                case "default": {
                    return true;
                }
            }
            throw new ConfigurationException("Unknown instrumentation mode: " + mode);
        }
        return (Boolean)environment.getProperty("otel.instrumentation.common.default-enabled", Boolean.class, (Object)true);
    }

    public static String translatePropertyName(Environment environment, String name) {
        if (EarlyConfig.isDeclarativeConfig(environment)) {
            if (name.startsWith("otel.instrumentation.")) {
                return EarlyConfig.toSnakeCase(String.format("otel.instrumentation/development.java.%s", name.substring("otel.instrumentation.".length())));
            }
            throw new IllegalStateException("No mapping found for property name: " + name + ". Please report this bug.");
        }
        return name;
    }

    private static String toSnakeCase(String string) {
        return string.replace('-', '_');
    }

    public static boolean isInstrumentationEnabled(Environment environment, String name, boolean defaultValue) {
        String property = EarlyConfig.getPropertyName(environment, String.format("otel.instrumentation.%s.enabled", name), String.format("otel.instrumentation/development.java.%s.enabled", EarlyConfig.toSnakeCase(name)));
        Boolean explicit = (Boolean)environment.getProperty(property, Boolean.class);
        if (explicit != null) {
            return explicit;
        }
        if (!defaultValue) {
            return false;
        }
        return EarlyConfig.isDefaultEnabled(environment);
    }

    private static String getPropertyName(Environment environment, String propertyBased, String declarative) {
        return EarlyConfig.isDeclarativeConfig(environment) ? declarative : propertyBased;
    }
}

