/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.scheduling;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeSpanNameExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.util.ClassAndMethod;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.framework.AopProxyUtils;

@Aspect
final class SpringSchedulingInstrumentationAspect {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-boot-autoconfigure";
    private final Instrumenter<ClassAndMethod, Object> instrumenter;

    public SpringSchedulingInstrumentationAspect(OpenTelemetry openTelemetry, InstrumentationConfig config) {
        CodeAttributesGetter codedAttributesGetter = ClassAndMethod.codeAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)CodeSpanNameExtractor.create((CodeAttributesGetter)codedAttributesGetter)).addAttributesExtractor(CodeAttributesExtractor.create((CodeAttributesGetter)codedAttributesGetter));
        if (config.getBoolean("otel.instrumentation.spring-scheduling.experimental-span-attributes", false)) {
            builder.addAttributesExtractor(AttributesExtractor.constant((AttributeKey)AttributeKey.stringKey((String)"job.system"), (Object)"spring_scheduling"));
        }
        this.instrumenter = builder.buildInstrumenter();
    }

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Scheduled)|| @annotation(org.springframework.scheduling.annotation.Schedules)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object execution(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object;
        ClassAndMethod request;
        Context parent = Context.current();
        if (!this.instrumenter.shouldStart(parent, (Object)(request = ClassAndMethod.create((Class)AopProxyUtils.ultimateTargetClass((Object)joinPoint.getTarget()), (String)((MethodSignature)joinPoint.getSignature()).getMethod().getName())))) {
            return joinPoint.proceed();
        }
        Context context = this.instrumenter.start(parent, (Object)request);
        try (Scope ignored = context.makeCurrent();){
            object = joinPoint.proceed();
        }
        catch (Throwable t) {
            this.instrumenter.end(context, (Object)request, null, t);
            throw t;
        }
        this.instrumenter.end(context, (Object)request, object, null);
        return object;
    }
}

