/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.springframework.core.env.Environment;

final class CachedPropertyResolver {
    private final Environment environment;
    private final ConcurrentHashMap<CacheKey, Optional<?>> cache = new ConcurrentHashMap();

    CachedPropertyResolver(Environment environment) {
        this.environment = Objects.requireNonNull(environment, "environment");
    }

    @Nullable
    <T> T getProperty(String name, Class<T> targetType) {
        CacheKey key = new CacheKey(name, targetType);
        return targetType.cast(this.cache.computeIfAbsent(key, k -> Optional.ofNullable(this.environment.getProperty(name, targetType))).orElse(null));
    }

    @Nullable
    String getProperty(String name) {
        return this.getProperty(name, String.class);
    }

    void clear() {
        this.cache.clear();
    }

    private static final class CacheKey {
        private final String name;
        private final Class<?> targetType;
        private final int cachedHashCode;

        CacheKey(String name, Class<?> targetType) {
            this.name = Objects.requireNonNull(name, "name");
            this.targetType = Objects.requireNonNull(targetType, "targetType");
            this.cachedHashCode = Objects.hash(name, targetType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.name.equals(other.name) && this.targetType.equals(other.targetType);
        }

        public int hashCode() {
            return this.cachedHashCode;
        }
    }
}

