/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.webflux;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.ConditionalOnEnabledInstrumentation;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.webflux.WebClientBeanPostProcessor;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.WebFilter;

@ConditionalOnEnabledInstrumentation(module="spring-webflux")
@ConditionalOnClass(value={WebClient.class})
@Configuration
public class SpringWebfluxInstrumentationAutoConfiguration {
    @Bean
    static WebClientBeanPostProcessor otelWebClientBeanPostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider, ObjectProvider<ConfigProperties> configPropertiesProvider) {
        return new WebClientBeanPostProcessor(openTelemetryProvider, configPropertiesProvider);
    }

    @Bean
    WebFilter telemetryFilter(OpenTelemetry openTelemetry, ConfigProperties config) {
        return WebClientBeanPostProcessor.getWebfluxTelemetry(openTelemetry, config).createWebFilterAndRegisterReactorHook();
    }
}

