/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties;

import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtelResourceProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.OtlpExporterProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.properties.PropagationProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.core.env.Environment;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpringConfigProperties
implements ConfigProperties {
    private final Environment environment;
    private final ExpressionParser parser;
    private final OtlpExporterProperties otlpExporterProperties;
    private final OtelResourceProperties resourceProperties;
    private final PropagationProperties propagationProperties;
    private final ConfigProperties otelSdkProperties;

    public SpringConfigProperties(Environment environment, ExpressionParser parser, OtlpExporterProperties otlpExporterProperties, OtelResourceProperties resourceProperties, PropagationProperties propagationProperties, ConfigProperties otelSdkProperties) {
        this.environment = environment;
        this.parser = parser;
        this.otlpExporterProperties = otlpExporterProperties;
        this.resourceProperties = resourceProperties;
        this.propagationProperties = propagationProperties;
        this.otelSdkProperties = otelSdkProperties;
    }

    public static ConfigProperties create(Environment env, OtlpExporterProperties otlpExporterProperties, OtelResourceProperties resourceProperties, PropagationProperties propagationProperties, ConfigProperties fallback) {
        return new SpringConfigProperties(env, (ExpressionParser)new SpelExpressionParser(), otlpExporterProperties, resourceProperties, propagationProperties, fallback);
    }

    @Nullable
    public String getString(String name) {
        String value = (String)this.environment.getProperty(name, String.class);
        if (value == null && name.equals("otel.exporter.otlp.protocol")) {
            return "http/protobuf";
        }
        return SpringConfigProperties.or(value, this.otelSdkProperties.getString(name));
    }

    @Nullable
    public Boolean getBoolean(String name) {
        return SpringConfigProperties.or((Boolean)this.environment.getProperty(name, Boolean.class), this.otelSdkProperties.getBoolean(name));
    }

    @Nullable
    public Integer getInt(String name) {
        return SpringConfigProperties.or((Integer)this.environment.getProperty(name, Integer.class), this.otelSdkProperties.getInt(name));
    }

    @Nullable
    public Long getLong(String name) {
        return SpringConfigProperties.or((Long)this.environment.getProperty(name, Long.class), this.otelSdkProperties.getLong(name));
    }

    @Nullable
    public Double getDouble(String name) {
        return SpringConfigProperties.or((Double)this.environment.getProperty(name, Double.class), this.otelSdkProperties.getDouble(name));
    }

    public List<String> getList(String name) {
        if (name.equals("otel.propagators")) {
            return this.propagationProperties.getPropagators();
        }
        return SpringConfigProperties.or((List)this.environment.getProperty(name, List.class), this.otelSdkProperties.getList(name));
    }

    @Nullable
    public Duration getDuration(String name) {
        String value = this.getString(name);
        if (value == null) {
            return this.otelSdkProperties.getDuration(name);
        }
        return DefaultConfigProperties.createFromMap(Collections.singletonMap(name, value)).getDuration(name);
    }

    public Map<String, String> getMap(String name) {
        Map otelSdkMap = this.otelSdkProperties.getMap(name);
        switch (name) {
            case "otel.resource.attributes": {
                return SpringConfigProperties.mergeWithOtel(this.resourceProperties.getAttributes(), otelSdkMap);
            }
            case "otel.exporter.otlp.headers": {
                return SpringConfigProperties.mergeWithOtel(this.otlpExporterProperties.getHeaders(), otelSdkMap);
            }
            case "otel.exporter.otlp.logs.headers": {
                return SpringConfigProperties.mergeWithOtel(this.otlpExporterProperties.getLogs().getHeaders(), otelSdkMap);
            }
            case "otel.exporter.otlp.metrics.headers": {
                return SpringConfigProperties.mergeWithOtel(this.otlpExporterProperties.getMetrics().getHeaders(), otelSdkMap);
            }
            case "otel.exporter.otlp.traces.headers": {
                return SpringConfigProperties.mergeWithOtel(this.otlpExporterProperties.getTraces().getHeaders(), otelSdkMap);
            }
        }
        String value = this.environment.getProperty(name);
        if (value == null) {
            return otelSdkMap;
        }
        return (Map)this.parser.parseExpression(value).getValue();
    }

    private static Map<String, String> mergeWithOtel(Map<String, String> springMap, Map<String, String> otelSdkMap) {
        HashMap<String, String> merged = new HashMap<String, String>(otelSdkMap);
        merged.putAll(springMap);
        return merged;
    }

    @Nullable
    private static <T> T or(@Nullable T first, @Nullable T second) {
        return first != null ? first : second;
    }
}

