/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.kafka;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.kafkaclients.KafkaTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.kafka.ConcurrentKafkaListenerContainerFactoryPostProcessor;
import io.opentelemetry.instrumentation.spring.autoconfigure.kafka.KafkaInstrumentationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaProducerFactoryCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@EnableConfigurationProperties(value={KafkaInstrumentationProperties.class})
@ConditionalOnProperty(name={"otel.springboot.kafka.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={KafkaTemplate.class, ConcurrentKafkaListenerContainerFactory.class})
public class KafkaInstrumentationAutoConfiguration {
    @Bean
    public DefaultKafkaProducerFactoryCustomizer producerInstrumentation(OpenTelemetry openTelemetry) {
        KafkaTelemetry kafkaTelemetry = KafkaTelemetry.create((OpenTelemetry)openTelemetry);
        return producerFactory -> producerFactory.addPostProcessor(arg_0 -> ((KafkaTelemetry)kafkaTelemetry).wrap(arg_0));
    }

    @Bean
    public ConcurrentKafkaListenerContainerFactoryPostProcessor concurrentKafkaListenerContainerFactoryPostProcessor(OpenTelemetry openTelemetry) {
        return new ConcurrentKafkaListenerContainerFactoryPostProcessor(openTelemetry);
    }
}

