/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.exporters.otlp;

import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryAutoConfiguration;
import io.opentelemetry.instrumentation.spring.autoconfigure.exporters.otlp.OtlpExporterProperties;
import java.time.Duration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfigureBefore(value={OpenTelemetryAutoConfiguration.class})
@EnableConfigurationProperties(value={OtlpExporterProperties.class})
@ConditionalOnProperty(prefix="otel.exporter.otlp", name={"enabled", "logs.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={OtlpGrpcLogRecordExporter.class})
public class OtlpLoggerExporterAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OtlpGrpcLogRecordExporter otelOtlpGrpcLogRecordExporter(OtlpExporterProperties properties) {
        Duration timeout;
        OtlpGrpcLogRecordExporterBuilder builder = OtlpGrpcLogRecordExporter.builder();
        String endpoint = properties.getLogs().getEndpoint();
        if (endpoint == null) {
            endpoint = properties.getEndpoint();
        }
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = properties.getLogs().getTimeout()) == null) {
            timeout = properties.getTimeout();
        }
        if (timeout != null) {
            builder.setTimeout(timeout);
        }
        return builder.build();
    }
}

