/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.annotations;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.annotation.support.MethodSpanAttributesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndSupport;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.code.CodeAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.annotations.JoinPointRequest;
import io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.annotations.JointPointCodeAttributesExtractor;
import io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.annotations.WithSpanAspectParameterAttributeNamesExtractor;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.core.ParameterNameDiscoverer;

abstract class WithSpanAspect {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-boot-autoconfigure";
    private final Instrumenter<JoinPointRequest, Object> instrumenter;
    private final JoinPointRequest.Factory requestFactory;

    WithSpanAspect(OpenTelemetry openTelemetry, ParameterNameDiscoverer parameterNameDiscoverer, JoinPointRequest.Factory requestFactory, WithSpanAspectParameterAttributeNamesExtractor.SpanAttributeNameSupplier spanAttributeNameSupplier) {
        WithSpanAspectParameterAttributeNamesExtractor parameterAttributeNamesExtractor = new WithSpanAspectParameterAttributeNamesExtractor(parameterNameDiscoverer, spanAttributeNameSupplier);
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, JoinPointRequest::spanName).addAttributesExtractor(CodeAttributesExtractor.create((CodeAttributesGetter)JointPointCodeAttributesExtractor.INSTANCE)).addAttributesExtractor((AttributesExtractor)MethodSpanAttributesExtractor.create(JoinPointRequest::method, (ParameterAttributeNamesExtractor)parameterAttributeNamesExtractor, JoinPointRequest::args)).buildInstrumenter(JoinPointRequest::spanKind);
        this.requestFactory = requestFactory;
    }

    public Object traceMethod(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        block9: {
            JoinPointRequest request = this.requestFactory.create((JoinPoint)pjp);
            Context parentContext = Context.current();
            if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
                return pjp.proceed();
            }
            Context context = this.instrumenter.start(parentContext, (Object)request);
            AsyncOperationEndSupport asyncOperationEndSupport = AsyncOperationEndSupport.create(this.instrumenter, Object.class, request.method().getReturnType());
            Scope ignored = context.makeCurrent();
            try {
                Object response = pjp.proceed();
                object = asyncOperationEndSupport.asyncEnd(context, (Object)request, response, null);
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    asyncOperationEndSupport.asyncEnd(context, (Object)request, null, t);
                    throw t;
                }
            }
            ignored.close();
        }
        return object;
    }
}

