/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.exporters.logging;

import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryAutoConfiguration;
import io.opentelemetry.instrumentation.spring.autoconfigure.exporters.logging.LoggingExporterProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration
@EnableConfigurationProperties(value={LoggingExporterProperties.class})
@AutoConfigureBefore(value={OpenTelemetryAutoConfiguration.class})
@Conditional(value={AnyPropertyEnabled.class})
@ConditionalOnClass(value={LoggingSpanExporter.class})
public class LoggingSpanExporterAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LoggingSpanExporter otelLoggingSpanExporter() {
        return LoggingSpanExporter.create();
    }

    static final class AnyPropertyEnabled
    extends AnyNestedCondition {
        AnyPropertyEnabled() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"otel.exporter.logging.traces.enabled"})
        static class LoggingTracesEnabled {
            LoggingTracesEnabled() {
            }
        }

        @ConditionalOnProperty(value={"otel.exporter.logging.enabled"})
        static class LoggingEnabled {
            LoggingEnabled() {
            }
        }
    }
}

