/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.resources;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.spring.autoconfigure.resources.OtelResourceProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ResourceAttributes;
import java.util.Map;

public class SpringResourceProvider
implements ResourceProvider {
    private final OtelResourceProperties otelResourceProperties;

    public SpringResourceProvider(OtelResourceProperties otelResourceProperties) {
        this.otelResourceProperties = otelResourceProperties;
    }

    public Resource createResource(ConfigProperties configProperties) {
        String applicationName = configProperties.getString("spring.application.name");
        Map<String, String> attributes = this.otelResourceProperties.getAttributes();
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return SpringResourceProvider.defaultResource(applicationName).merge(Resource.create((Attributes)attributesBuilder.build()));
    }

    private static Resource defaultResource(String applicationName) {
        if (applicationName == null) {
            return Resource.getDefault();
        }
        return Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)applicationName)));
    }
}

