/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.exporters.otlp;

import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryAutoConfiguration;
import io.opentelemetry.instrumentation.spring.autoconfigure.exporters.otlp.OtlpExporterProperties;
import java.time.Duration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={OpenTelemetryAutoConfiguration.class})
@EnableConfigurationProperties(value={OtlpExporterProperties.class})
@ConditionalOnProperty(prefix="otel.exporter.otlp", name={"enabled", "traces.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={OtlpGrpcSpanExporter.class})
public class OtlpSpanExporterAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OtlpGrpcSpanExporter otelOtlpGrpcSpanExporter(OtlpExporterProperties properties) {
        Duration timeout;
        OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
        String endpoint = properties.getTraces().getEndpoint();
        if (endpoint == null) {
            endpoint = properties.getEndpoint();
        }
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = properties.getTraces().getTimeout()) == null) {
            timeout = properties.getTimeout();
        }
        if (timeout != null) {
            builder.setTimeout(timeout);
        }
        return builder.build();
    }
}

