/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.exporters.logging;

import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryAutoConfiguration;
import io.opentelemetry.instrumentation.spring.autoconfigure.exporters.internal.ExporterConfigEvaluator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@AutoConfigureBefore(value={OpenTelemetryAutoConfiguration.class})
@Conditional(value={CustomCondition.class})
@ConditionalOnClass(value={LoggingSpanExporter.class})
public class LoggingSpanExporterAutoConfiguration {
    @Bean(destroyMethod="")
    @ConditionalOnMissingBean
    public LoggingSpanExporter otelLoggingSpanExporter() {
        return LoggingSpanExporter.create();
    }

    static final class CustomCondition
    implements Condition {
        CustomCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ExporterConfigEvaluator.isExporterEnabled(context.getEnvironment(), "otel.exporter.logging.enabled", "otel.exporter.logging.traces.enabled", "otel.traces.exporter", "logging", false);
        }
    }
}

