/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.exporters.otlp;

import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.internal.OtlpLogRecordExporterProvider;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryAutoConfiguration;
import io.opentelemetry.instrumentation.spring.autoconfigure.exporters.internal.ExporterConfigEvaluator;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;

@AutoConfigureBefore(value={OpenTelemetryAutoConfiguration.class})
@Conditional(value={CustomCondition.class})
@ConditionalOnClass(value={OtlpGrpcLogRecordExporter.class})
public class OtlpLogRecordExporterAutoConfiguration {
    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={OtlpGrpcLogRecordExporter.class, OtlpHttpLogRecordExporter.class})
    public LogRecordExporter otelOtlpLogRecordExporter(ConfigProperties configProperties) {
        return new OtlpLogRecordExporterProvider().createExporter(configProperties);
    }

    static final class CustomCondition
    implements Condition {
        CustomCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ExporterConfigEvaluator.isExporterEnabled(context.getEnvironment(), "otel.exporter.otlp.enabled", "otel.exporter.otlp.logs.enabled", "otel.logs.exporter", "otlp", true);
        }
    }
}

