/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.exporters.zipkin;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryAutoConfiguration;
import io.opentelemetry.instrumentation.spring.autoconfigure.exporters.internal.ExporterConfigEvaluator;
import io.opentelemetry.instrumentation.spring.autoconfigure.exporters.zipkin.ZipkinSpanExporterProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@AutoConfigureBefore(value={OpenTelemetryAutoConfiguration.class})
@EnableConfigurationProperties(value={ZipkinSpanExporterProperties.class})
@Conditional(value={CustomCondition.class})
@ConditionalOnClass(value={ZipkinSpanExporter.class})
public class ZipkinSpanExporterAutoConfiguration {
    @Bean(destroyMethod="")
    @ConditionalOnMissingBean
    public ZipkinSpanExporter otelZipkinSpanExporter(ZipkinSpanExporterProperties properties) {
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        if (properties.getEndpoint() != null) {
            builder.setEndpoint(properties.getEndpoint());
        }
        return builder.build();
    }

    static final class CustomCondition
    implements Condition {
        CustomCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ExporterConfigEvaluator.isExporterEnabled(context.getEnvironment(), null, "otel.exporter.zipkin.enabled", "otel.traces.exporter", "zipkin", true);
        }
    }
}

