/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;

public class LogbackAppenderApplicationListener
implements GenericApplicationListener {
    private static final Class<?>[] SOURCE_TYPES = new Class[]{SpringApplication.class, ApplicationContext.class};
    private static final Class<?>[] EVENT_TYPES = new Class[]{ApplicationEnvironmentPreparedEvent.class};

    public boolean supportsSourceType(Class<?> sourceType) {
        return LogbackAppenderApplicationListener.isAssignableFrom(sourceType, SOURCE_TYPES);
    }

    public boolean supportsEventType(ResolvableType resolvableType) {
        return LogbackAppenderApplicationListener.isAssignableFrom(resolvableType.getRawClass(), EVENT_TYPES);
    }

    private static boolean isAssignableFrom(Class<?> type, Class<?> ... supportedTypes) {
        if (type != null) {
            for (Class<?> supportedType : supportedTypes) {
                if (!supportedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            Optional<OpenTelemetryAppender> existingOpenTelemetryAppender = LogbackAppenderApplicationListener.findOpenTelemetryAppender();
            ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent = (ApplicationEnvironmentPreparedEvent)event;
            if (existingOpenTelemetryAppender.isPresent()) {
                LogbackAppenderApplicationListener.reInitializeOpenTelemetryAppender(existingOpenTelemetryAppender, applicationEnvironmentPreparedEvent);
            } else {
                LogbackAppenderApplicationListener.addOpenTelemetryAppender(applicationEnvironmentPreparedEvent);
            }
        }
    }

    private static void reInitializeOpenTelemetryAppender(Optional<OpenTelemetryAppender> existingOpenTelemetryAppender, ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        OpenTelemetryAppender openTelemetryAppender = existingOpenTelemetryAppender.get();
        openTelemetryAppender.stop();
        LogbackAppenderApplicationListener.initializeOpenTelemetryAppenderFromProperties(applicationEnvironmentPreparedEvent, openTelemetryAppender);
        openTelemetryAppender.start();
    }

    private static void addOpenTelemetryAppender(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent) {
        Logger logger = (Logger)LoggerFactory.getILoggerFactory().getLogger("ROOT");
        OpenTelemetryAppender openTelemetryAppender = new OpenTelemetryAppender();
        LogbackAppenderApplicationListener.initializeOpenTelemetryAppenderFromProperties(applicationEnvironmentPreparedEvent, openTelemetryAppender);
        openTelemetryAppender.start();
        logger.addAppender((Appender)openTelemetryAppender);
    }

    private static void initializeOpenTelemetryAppenderFromProperties(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent, OpenTelemetryAppender openTelemetryAppender) {
        String mdcAttributeProperty;
        Boolean loggerContextAttributes;
        Boolean logAttributes;
        Boolean keyValuePairAttributes;
        Boolean markerAttribute;
        Boolean codeAttribute = LogbackAppenderApplicationListener.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-code-attributes");
        if (codeAttribute != null) {
            openTelemetryAppender.setCaptureCodeAttributes(codeAttribute.booleanValue());
        }
        if ((markerAttribute = LogbackAppenderApplicationListener.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-marker-attribute")) != null) {
            openTelemetryAppender.setCaptureMarkerAttribute(markerAttribute.booleanValue());
        }
        if ((keyValuePairAttributes = LogbackAppenderApplicationListener.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-key-value-pair-attributes")) != null) {
            openTelemetryAppender.setCaptureKeyValuePairAttributes(keyValuePairAttributes.booleanValue());
        }
        if ((logAttributes = LogbackAppenderApplicationListener.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental-log-attributes")) != null) {
            openTelemetryAppender.setCaptureExperimentalAttributes(logAttributes.booleanValue());
        }
        if ((loggerContextAttributes = LogbackAppenderApplicationListener.evaluateBooleanProperty(applicationEnvironmentPreparedEvent, "otel.instrumentation.logback-appender.experimental.capture-logger-context-attributes")) != null) {
            openTelemetryAppender.setCaptureLoggerContext(loggerContextAttributes.booleanValue());
        }
        if ((mdcAttributeProperty = (String)applicationEnvironmentPreparedEvent.getEnvironment().getProperty("otel.instrumentation.logback-appender.experimental.capture-mdc-attributes", String.class)) != null) {
            openTelemetryAppender.setCaptureMdcAttributes(mdcAttributeProperty);
        }
    }

    private static Boolean evaluateBooleanProperty(ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent, String property) {
        return (Boolean)applicationEnvironmentPreparedEvent.getEnvironment().getProperty(property, Boolean.class);
    }

    private static Optional<OpenTelemetryAppender> findOpenTelemetryAppender() {
        ILoggerFactory loggerFactorySpi = LoggerFactory.getILoggerFactory();
        if (!(loggerFactorySpi instanceof LoggerContext)) {
            return Optional.empty();
        }
        LoggerContext loggerContext = (LoggerContext)loggerFactorySpi;
        for (Logger logger : loggerContext.getLoggerList()) {
            Iterator appenderIterator = logger.iteratorForAppenders();
            while (appenderIterator.hasNext()) {
                Appender appender = (Appender)appenderIterator.next();
                if (!(appender instanceof OpenTelemetryAppender)) continue;
                OpenTelemetryAppender openTelemetryAppender = (OpenTelemetryAppender)appender;
                return Optional.of(openTelemetryAppender);
            }
        }
        return Optional.empty();
    }

    public int getOrder() {
        return -2147483627;
    }
}

