/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.resources;

import io.opentelemetry.instrumentation.spring.autoconfigure.exporters.otlp.OtlpExporterProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.propagators.PropagationProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.core.env.Environment;
import org.springframework.expression.ExpressionParser;

public class SpringConfigProperties
implements ConfigProperties {
    private final Environment environment;
    private final ExpressionParser parser;
    private final OtlpExporterProperties otlpExporterProperties;
    private final PropagationProperties propagationProperties;

    public SpringConfigProperties(Environment environment, ExpressionParser parser, OtlpExporterProperties otlpExporterProperties, PropagationProperties propagationProperties) {
        this.environment = environment;
        this.parser = parser;
        this.otlpExporterProperties = otlpExporterProperties;
        this.propagationProperties = propagationProperties;
    }

    @Nullable
    public String getString(String name) {
        String value = (String)this.environment.getProperty(name, String.class);
        if (value == null && name.equals("otel.exporter.otlp.protocol")) {
            return "http/protobuf";
        }
        return value;
    }

    @Nullable
    public Boolean getBoolean(String name) {
        return (Boolean)this.environment.getProperty(name, Boolean.class);
    }

    @Nullable
    public Integer getInt(String name) {
        return (Integer)this.environment.getProperty(name, Integer.class);
    }

    @Nullable
    public Long getLong(String name) {
        return (Long)this.environment.getProperty(name, Long.class);
    }

    @Nullable
    public Double getDouble(String name) {
        return (Double)this.environment.getProperty(name, Double.class);
    }

    public List<String> getList(String name) {
        if (name.equals("otel.propagators")) {
            return this.propagationProperties.getPropagators();
        }
        List value = (List)this.environment.getProperty(name, List.class);
        return value == null ? Collections.emptyList() : value;
    }

    @Nullable
    public Duration getDuration(String name) {
        String value = this.getString(name);
        if (value == null) {
            return null;
        }
        return DefaultConfigProperties.createFromMap(Collections.singletonMap(name, value)).getDuration(name);
    }

    public Map<String, String> getMap(String name) {
        switch (name) {
            case "otel.exporter.otlp.headers": {
                return this.otlpExporterProperties.getHeaders();
            }
            case "otel.exporter.otlp.logs.headers": {
                return this.otlpExporterProperties.getLogs().getHeaders();
            }
            case "otel.exporter.otlp.metrics.headers": {
                return this.otlpExporterProperties.getMetrics().getHeaders();
            }
            case "otel.exporter.otlp.traces.headers": {
                return this.otlpExporterProperties.getTraces().getHeaders();
            }
        }
        String value = this.environment.getProperty(name);
        if (value == null) {
            return Collections.emptyMap();
        }
        return (Map)this.parser.parseExpression(value).getValue();
    }
}

