/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.resources;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.spring.autoconfigure.resources.OtelResourceProperties;
import io.opentelemetry.instrumentation.spring.autoconfigure.resources.OtelSpringResourceProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ResourceAttributes;

public class SpringResourceProvider
implements ResourceProvider {
    private final OtelSpringResourceProperties otelSpringResourceProperties;
    private final OtelResourceProperties otelResourceProperties;

    public SpringResourceProvider(OtelSpringResourceProperties otelSpringResourceProperties, OtelResourceProperties otelResourceProperties) {
        this.otelSpringResourceProperties = otelSpringResourceProperties;
        this.otelResourceProperties = otelResourceProperties;
    }

    public Resource createResource(ConfigProperties configProperties) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        String springApplicationName = configProperties.getString("spring.application.name");
        if (springApplicationName != null) {
            attributesBuilder.put(ResourceAttributes.SERVICE_NAME, (Object)springApplicationName);
        }
        this.otelSpringResourceProperties.getAttributes().forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        this.otelResourceProperties.getAttributes().forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        String applicationName = configProperties.getString("otel.service.name");
        if (applicationName != null) {
            attributesBuilder.put(ResourceAttributes.SERVICE_NAME, (Object)applicationName);
        }
        return Resource.create((Attributes)attributesBuilder.build());
    }
}

