/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.r2dbc.v1_0.R2dbcTelemetry;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.DbExecution;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.R2dbcInstrumenterBuilder;
import java.util.function.Function;

public final class R2dbcTelemetryBuilder {
    private final R2dbcInstrumenterBuilder instrumenterBuilder;
    private boolean statementSanitizationEnabled = true;
    private Function<SpanNameExtractor<DbExecution>, ? extends SpanNameExtractor<? super DbExecution>> spanNameExtractorTransformer = Function.identity();

    R2dbcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.instrumenterBuilder = new R2dbcInstrumenterBuilder(openTelemetry);
    }

    @CanIgnoreReturnValue
    public R2dbcTelemetryBuilder addAttributeExtractor(AttributesExtractor<DbExecution, Void> attributesExtractor) {
        this.instrumenterBuilder.addAttributeExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public R2dbcTelemetryBuilder setStatementSanitizationEnabled(boolean enabled) {
        this.statementSanitizationEnabled = enabled;
        return this;
    }

    @CanIgnoreReturnValue
    public R2dbcTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<DbExecution>, ? extends SpanNameExtractor<? super DbExecution>> spanNameExtractorTransformer) {
        this.spanNameExtractorTransformer = spanNameExtractorTransformer;
        return this;
    }

    public R2dbcTelemetry build() {
        return new R2dbcTelemetry(this.instrumenterBuilder.build(this.spanNameExtractorTransformer, this.statementSanitizationEnabled));
    }
}

