/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.DbExecution;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.QueryExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.listener.ProxyMethodExecutionListener;
import io.r2dbc.spi.ConnectionFactoryOptions;

public final class TraceProxyListener
implements ProxyMethodExecutionListener {
    private static final String KEY_DB_EXECUTION = "dbExecution";
    private final Instrumenter<DbExecution, Void> instrumenter;
    private final ConnectionFactoryOptions factoryOptions;

    public TraceProxyListener(Instrumenter<DbExecution, Void> instrumenter, ConnectionFactoryOptions factoryOptions) {
        this.instrumenter = instrumenter;
        this.factoryOptions = factoryOptions;
    }

    @Override
    public void beforeQuery(QueryExecutionInfo queryInfo) {
        DbExecution dbExecution;
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)(dbExecution = new DbExecution(queryInfo, this.factoryOptions)))) {
            return;
        }
        dbExecution.setContext(this.instrumenter.start(parentContext, (Object)dbExecution));
        queryInfo.getValueStore().put(KEY_DB_EXECUTION, dbExecution);
    }

    @Override
    public void afterQuery(QueryExecutionInfo queryInfo) {
        DbExecution dbExecution = (DbExecution)queryInfo.getValueStore().get(KEY_DB_EXECUTION);
        if (dbExecution != null && dbExecution.getContext() != null) {
            this.instrumenter.end(dbExecution.getContext(), (Object)dbExecution, null, queryInfo.getThrowable());
        }
    }
}

