/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.callback;

import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.callback.StopWatch;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class QueriesExecutionContext {
    private static final AtomicIntegerFieldUpdater<QueriesExecutionContext> PRODUCED_COUNT_INCREMENTER = AtomicIntegerFieldUpdater.newUpdater(QueriesExecutionContext.class, "resultProducedCount");
    private static final AtomicIntegerFieldUpdater<QueriesExecutionContext> CONSUMED_COUNT_INCREMENTER = AtomicIntegerFieldUpdater.newUpdater(QueriesExecutionContext.class, "resultConsumedCount");
    private volatile int resultProducedCount;
    private volatile int resultConsumedCount;
    private final StopWatch stopWatch;
    private boolean allProduced;

    public QueriesExecutionContext(Clock clock) {
        this.stopWatch = new StopWatch(clock);
    }

    public void incrementProducedCount() {
        PRODUCED_COUNT_INCREMENTER.incrementAndGet(this);
    }

    public void incrementConsumedCount() {
        CONSUMED_COUNT_INCREMENTER.incrementAndGet(this);
    }

    public Duration getElapsedDuration() {
        return this.stopWatch.getElapsedDuration();
    }

    public void startStopwatch() {
        this.stopWatch.start();
    }

    public boolean isQueryFinished() {
        return this.allProduced && this.isAllConsumed();
    }

    public boolean isAllConsumed() {
        return this.resultConsumedCount >= this.resultProducedCount;
    }

    public void markAllProduced() {
        this.allProduced = true;
    }
}

