/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.callback;

import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.callback.ProxyConfig;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.ConnectionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.QueryExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import java.lang.reflect.Method;
import reactor.util.annotation.Nullable;

public final class RowSegmentCallbackHandler
extends CallbackHandlerSupport {
    private final Result.RowSegment rowSegment;
    private final QueryExecutionInfo queryExecutionInfo;

    public RowSegmentCallbackHandler(Result.RowSegment rowSegment, QueryExecutionInfo queryExecutionInfo, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.rowSegment = Assert.requireNonNull(rowSegment, "rowSegment must not be null");
        this.queryExecutionInfo = Assert.requireNonNull(queryExecutionInfo, "queryExecutionInfo must not be null");
    }

    @Override
    public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        ConnectionInfo connectionInfo = this.queryExecutionInfo.getConnectionInfo();
        if (this.isCommonMethod(methodName)) {
            return this.handleCommonMethod(methodName, this.rowSegment, args, connectionInfo.getOriginalConnection());
        }
        Object result = this.proceedExecution(method, this.rowSegment, args, this.proxyConfig.getListeners(), connectionInfo, null);
        if ("row".equals(methodName)) {
            return this.proxyConfig.getProxyFactory().wrapRow((Row)result, this.queryExecutionInfo);
        }
        return result;
    }
}

