/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.observation.QueryContext;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.observation.R2dbcObservationDocumentation;
import java.util.HashSet;

public interface QueryObservationConvention
extends ObservationConvention<QueryContext> {
    default public boolean supportsContext(Observation.Context context) {
        return context instanceof QueryContext;
    }

    default public String getName() {
        return "r2dbc.query";
    }

    default public String getContextualName(QueryContext context) {
        return "query";
    }

    default public KeyValues getLowCardinalityKeyValues(QueryContext context) {
        HashSet<KeyValue> keyValues = new HashSet<KeyValue>();
        keyValues.add(KeyValue.of((KeyName)R2dbcObservationDocumentation.LowCardinalityKeys.CONNECTION, (String)context.getConnectionName()));
        keyValues.add(KeyValue.of((KeyName)R2dbcObservationDocumentation.LowCardinalityKeys.THREAD, (String)context.getThreadName()));
        return KeyValues.of(keyValues);
    }

    default public KeyValues getHighCardinalityKeyValues(QueryContext context) {
        int i;
        HashSet<KeyValue> keyValues = new HashSet<KeyValue>();
        for (i = 0; i < context.getQueries().size(); ++i) {
            String key = context.getQueries().get(i);
            String queryKey = String.format(R2dbcObservationDocumentation.HighCardinalityKeys.QUERY.asString(), i);
            keyValues.add(KeyValue.of((String)queryKey, (String)key));
        }
        for (i = 0; i < context.getParams().size(); ++i) {
            String params = context.getParams().get(i);
            String key = String.format(R2dbcObservationDocumentation.HighCardinalityKeys.QUERY_PARAMETERS.asString(), i);
            keyValues.add(KeyValue.of((String)key, (String)params));
        }
        return KeyValues.of(keyValues);
    }
}

