/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.support;

import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.ConnectionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.MethodExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.support.FormatterUtils;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MethodExecutionInfoFormatter
implements Function<MethodExecutionInfo, String> {
    private static final String DEFAULT_DELIMITER = " ";
    private static final AtomicLongFieldUpdater<MethodExecutionInfoFormatter> SEQUENCE_NUMBER_INCREMENTER = AtomicLongFieldUpdater.newUpdater(MethodExecutionInfoFormatter.class, "sequenceNumber");
    private final List<BiConsumer<MethodExecutionInfo, StringBuilder>> consumers = new ArrayList<BiConsumer<MethodExecutionInfo, StringBuilder>>();
    private volatile long sequenceNumber = 0L;
    private BiConsumer<MethodExecutionInfo, StringBuilder> defaultConsumer = (executionInfo, sb) -> {
        long seq = SEQUENCE_NUMBER_INCREMENTER.incrementAndGet(this);
        long executionTime = executionInfo.getExecuteDuration().toMillis();
        String targetClass = executionInfo.getTarget().getClass().getSimpleName();
        String methodName = executionInfo.getMethod().getName();
        long threadId = executionInfo.getThreadId();
        ConnectionInfo connectionInfo = executionInfo.getConnectionInfo();
        String connectionId = connectionInfo == null || connectionInfo.getConnectionId() == null ? "n/a" : connectionInfo.getConnectionId();
        sb.append(String.format("%3d: Thread:%d Connection:%s Time:%d  %s#%s()", seq, threadId, connectionId, executionTime, targetClass, methodName));
    };
    private String delimiter = " ";

    public static MethodExecutionInfoFormatter withDefault() {
        MethodExecutionInfoFormatter formatter = new MethodExecutionInfoFormatter();
        formatter.addConsumer(formatter.defaultConsumer);
        return formatter;
    }

    public MethodExecutionInfoFormatter() {
    }

    private MethodExecutionInfoFormatter(MethodExecutionInfoFormatter formatter) {
        this.delimiter = formatter.delimiter;
        this.consumers.addAll(formatter.consumers);
    }

    @Override
    public String apply(MethodExecutionInfo executionInfo) {
        Assert.requireNonNull(executionInfo, "executionInfo must not be null");
        return this.format(executionInfo);
    }

    public String format(MethodExecutionInfo executionInfo) {
        Assert.requireNonNull(executionInfo, "executionInfo must not be null");
        StringBuilder sb = new StringBuilder();
        this.consumers.forEach(consumer -> {
            consumer.accept(executionInfo, sb);
            sb.append(this.delimiter);
        });
        FormatterUtils.chompIfEndWith(sb, this.delimiter);
        return sb.toString();
    }

    public MethodExecutionInfoFormatter addConsumer(BiConsumer<MethodExecutionInfo, StringBuilder> consumer) {
        Assert.requireNonNull(consumer, "consumer must not be null");
        this.consumers.add(consumer);
        return new MethodExecutionInfoFormatter(this);
    }
}

