/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.webflux;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.autoconfigure.instrumentation.webflux.WebClientBeanPostProcessor;
import io.opentelemetry.instrumentation.spring.autoconfigure.internal.ConditionalOnEnabledInstrumentation;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxTelemetry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.WebFilter;

@ConditionalOnEnabledInstrumentation(module="spring-webflux")
@ConditionalOnClass(value={WebClient.class})
@Configuration
public class SpringWebfluxInstrumentationAutoConfiguration {
    @Bean
    static WebClientBeanPostProcessor otelWebClientBeanPostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider) {
        return new WebClientBeanPostProcessor(openTelemetryProvider);
    }

    @Bean
    WebFilter telemetryFilter(OpenTelemetry openTelemetry) {
        return SpringWebfluxTelemetry.builder((OpenTelemetry)openTelemetry).build().createWebFilterAndRegisterReactorHook();
    }
}

