/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.QueryExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.QueryInfo;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.Locale;
import java.util.stream.Collectors;

public final class DbExecution {
    private static final String OTHER_SQL = "other_sql";
    private final String system;
    private final String user;
    private final String name;
    private final String host;
    private final Integer port;
    private final String connectionString;
    private final String rawStatement;
    private Context context;

    public DbExecution(QueryExecutionInfo queryInfo, ConnectionFactoryOptions factoryOptions) {
        Connection originalConnection = queryInfo.getConnectionInfo().getOriginalConnection();
        this.system = originalConnection != null ? originalConnection.getMetadata().getDatabaseProductName().toLowerCase(Locale.ROOT).split(" ")[0] : OTHER_SQL;
        this.user = factoryOptions.hasOption(ConnectionFactoryOptions.USER) ? (String)factoryOptions.getValue(ConnectionFactoryOptions.USER) : null;
        this.name = factoryOptions.hasOption(ConnectionFactoryOptions.DATABASE) ? ((String)factoryOptions.getValue(ConnectionFactoryOptions.DATABASE)).toLowerCase(Locale.ROOT) : null;
        String driver = factoryOptions.hasOption(ConnectionFactoryOptions.DRIVER) ? (String)factoryOptions.getValue(ConnectionFactoryOptions.DRIVER) : null;
        String protocol = factoryOptions.hasOption(ConnectionFactoryOptions.PROTOCOL) ? (String)factoryOptions.getValue(ConnectionFactoryOptions.PROTOCOL) : null;
        this.host = factoryOptions.hasOption(ConnectionFactoryOptions.HOST) ? (String)factoryOptions.getValue(ConnectionFactoryOptions.HOST) : null;
        this.port = factoryOptions.hasOption(ConnectionFactoryOptions.PORT) ? (Integer)factoryOptions.getValue(ConnectionFactoryOptions.PORT) : null;
        this.connectionString = String.format("%s%s:%s%s", driver != null ? driver : "", protocol != null ? ":" + protocol : "", this.host != null ? "//" + this.host : "", this.port != null ? ":" + this.port : "");
        this.rawStatement = queryInfo.getQueries().stream().map(QueryInfo::getQuery).collect(Collectors.joining(";\n"));
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getSystem() {
        return this.system;
    }

    public String getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getRawStatement() {
        return this.rawStatement;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String toString() {
        return "DbExecution{system='" + this.system + '\'' + ", user='" + this.user + '\'' + ", name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", connectionString='" + this.connectionString + '\'' + ", rawStatement='" + this.rawStatement + '\'' + ", context=" + this.context + '}';
    }
}

