/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core;

import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.core.ValueStore;
import io.opentelemetry.instrumentation.r2dbc.v1_0.shaded.io.r2dbc.proxy.util.Assert;
import java.util.HashMap;
import java.util.Map;

public class DefaultValueStore
implements ValueStore {
    private Map<Object, Object> map = new HashMap<Object, Object>();

    @Override
    public Object get(Object key) {
        Assert.requireNonNull(key, "key must not be null");
        return this.map.get(key);
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Assert.requireNonNull(key, "key must not be null");
        Assert.requireNonNull(type, "type must not be null");
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        return type.cast(value);
    }

    @Override
    public <T> T getOrDefault(Object key, T defaultValue) {
        Assert.requireNonNull(key, "key must not be null");
        Assert.requireNonNull(defaultValue, "type must not be null");
        Object value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    @Override
    public void put(Object key, Object value) {
        Assert.requireNonNull(key, "key must not be null");
        this.map.put(key, value);
    }

    @Override
    public void putAll(Map<Object, Object> map) {
        Assert.requireNonNull(map, "map must not be null");
        this.map.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        Assert.requireNonNull(key, "key must not be null");
        return this.map.remove(key);
    }
}

